/*
 * Written by Dawid Kurzyniec and released to the public domain, as explained
 * at http://creativecommons.org/licenses/publicdomain
 */

package edu.emory.mathcs.util.io;

import java.io.*;
import java.util.*;

/**
 * Character input source capable of redirecting
 * characters to a writer. It means that instead of reading characters into an
 * array and then feeding them to the writer, the characters may be moved
 * directly from the reader to the writer.
 *
 * @author Dawid Kurzyniec
 * @version 1.0
 */
public interface RedirectibleReader {

    /**
     * Reads and redirects up to the <code>len</code> characters to a
     * specified writer. Returns the number of characters actually redirected.
     *
     * @param dest the destination writer
     * @param len the maximum number of characters to redirect
     * @return number of characters actually redirected
     * @throws IOException if I/O error occurs
     */
    int redirect(Writer dest, int len) throws IOException;

    /**
     * Readirects all further data from this reader into the specified writer,
     * until EOF. Returns the number of characters actually redirected.
     *
     * @param dest the destination writer
     * @return number of characters actually redirected
     * @throws IOException if I/O error occurs
     */
    int redirectAll(Writer dest) throws IOException;
}
